﻿# -*- coding: utf-8 -*-
from future import standard_library
standard_library.install_aliases()
from builtins import map
from builtins import range
from ...plugin import _
from ...resources.imports import *
from ...resources.twagenthelper import twAgentGetPage

BASEURL = 'https://filmpalast.to'

fp_cookies = CookieJar()
fp_agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36'

default_cover = "file://%s/filmpalast.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class filmPalastMain(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("FilmPalast.to")
		self['ContentTitle'] = Label(_("Genre Selection"))

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = False
		self.suchString = ''
		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self._items.append(("--- Search ---", "callSuchen"))
		self._items.append(("Neueste Filme", "/movies/new/page/"))
		self._items.append(("Neueste Episoden", "/serien/view/page/"))
		self._items.append(("Serien", "/serien/view/page/"))
		self._items.append(("Abenteuer", "/search/genre/Abenteuer/"))
		self._items.append(("Action", "/search/genre/Action/"))
		self._items.append(("Adventure", "/search/genre/Adventure/"))
		self._items.append(("Animation", "/search/genre/Animation/"))
		self._items.append(("Biographie", "/search/genre/Biographie/"))
		self._items.append(("Comedy", "/search/genre/Comedy/"))
		self._items.append(("Crime", "/search/genre/Crime/"))
		self._items.append(("Documentary", "/search/genre/Documentary/"))
		self._items.append(("Drama", "/search/genre/Drama/"))
		self._items.append(("Familie", "/search/genre/Familie/"))
		self._items.append(("Fantasy", "/search/genre/Fantasy/"))
		self._items.append(("History", "/search/genre/History/"))
		self._items.append(("Horror", "/search/genre/Horror/"))
		self._items.append(("Komödie", "/search/genre/Kom%C3%B6die/"))
		self._items.append(("Krieg", "/search/genre/Krieg/"))
		self._items.append(("Krimi", "/search/genre/Krimi/"))
		self._items.append(("Musik", "/search/genre/Musik/"))
		self._items.append(("Mystery", "/search/genre/Mystery/"))
		self._items.append(("Romanze", "/search/genre/Romanze/"))
		self._items.append(("Sci-Fi", "/search/genre/Sci-Fi/"))
		self._items.append(("Sport", "/search/genre/Sport/"))
		self._items.append(("Thriller", "/search/genre/Thriller/"))
		self._items.append(("Western", "/search/genre/Western/"))
		self._items.append(("Zeichentrick", "/search/genre/Zeichentrick/"))
		self._items.append(("0-9", "/search/alpha/0-9/"))
		for c in range(26):
			self._items.append((chr(ord('A') + c), '/search/alpha/' + chr(ord('A') + c) + '/'))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False
		self.showInfos()

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Link = "%s/search/title/%s/" % (BASEURL, urllib.parse.quote(callback).replace(' ', '%20'))
			Name = self['liste'].getCurrent()[0][0]
			self.session.open(filmPalastParsing, Name, Link)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		auswahl = self['liste'].getCurrent()[0][0]
		url = BASEURL + self['liste'].getCurrent()[0][1]
		if auswahl == "--- Search ---":
			self.suchen()
		elif auswahl == "Serien":
			self.session.open(filmPalastSerieParsing, auswahl, url + "1")
		else:
			self.session.open(filmPalastParsing, auswahl, url)

class filmPalastSerieParsing(MPScreen):

	def __init__(self, session, genre, url):
		self.genre = genre
		self.url = url
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("FilmPalast.to")
		self['ContentTitle'] = Label("%s" % self.genre)

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self['name'].setText(_("Please wait..."))
		twAgentGetPage(self.url, agent=fp_agent, cookieJar=fp_cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		raw = MPfindall(self, '<section id="serien">(.*?)</section>', data, re.S)
		if raw:
			serien = MPfindall(self, '<a href="(%s/movies/view/.*?)">(.*?)<' % BASEURL, raw[0], re.S)
			if serien:
				for url, title in serien:
					self._items.append((decodeHtml(title), url))
		if len(self._items) == 0:
			self._items.append((_('No shows found!'), None))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		filmName = self['liste'].getCurrent()[0][0]
		self['name'].setText(filmName)
		url = self['liste'].getCurrent()[0][1]
		if url:
			coverUrl = url.replace('%smovies/view/' % BASEURL, '%s/files/movies/450/' % BASEURL) + '.jpg'
			CoverHelper(self['coverArt']).getCover(coverUrl, agent=fp_agent, cookieJar=fp_cookies)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		if url:
			self.session.open(filmPalastEpisodenParsing, stream_name, url)

class filmPalastEpisodenParsing(MPScreen):

	def __init__(self, session, genre, url):
		self.genre = genre
		self.url = url
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("FilmPalast.to")
		self['ContentTitle'] = Label(_("Episode Selection"))

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self['name'].setText(_("Please wait..."))
		twAgentGetPage(self.url, agent=fp_agent, cookieJar=fp_cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		episoden = MPfindall(self, '<a\s+id="staffId_"\n{0,1}\s+href="((?:https:|)//filmpalast.to/stream/.*?)"\n{0,1}\s+class="getStaffelStream".*?</i>(.*?)&', data, re.S)
		if episoden:
			for (Url, title) in episoden:
				if Url.startswith('//'):
					Url = "https:" + Url
				cover = Url.replace('%s/stream/' % BASEURL, '%s/files/movies/450/' % BASEURL) + '.jpg'
				self._items.append((decodeHtml(title).strip(), Url, cover))
		if len(self._items) == 0:
			self._items.append((_('No movies found!'), '', ''))
		self._items.sort()
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		filmName = self['liste'].getCurrent()[0][0]
		self['name'].setText(filmName)
		coverUrl = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(coverUrl, agent=fp_agent, cookieJar=fp_cookies)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		cover = self['liste'].getCurrent()[0][2]
		self.session.open(filmPalastStreams, stream_name, url, cover)

class filmPalastParsing(MPScreen):

	def __init__(self, session, genre, url):
		self.genre = genre
		self.url = url
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("FilmPalast.to")
		self['ContentTitle'] = Label("%s" % self.genre)

		self['Page'] = Label(_("Page:"))

		self.page = 1
		self.lastpage = 1
		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self['name'].setText(_("Please wait..."))
		url = self.url+str(self.page)
		twAgentGetPage(url, agent=fp_agent, cookieJar=fp_cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		self.getLastPage(data, 'id="paging">(.*?)</div>')
		movies = MPfindall(self, '<small class="rb">.*?<a href="((?:https:|)//filmpalast.to/.*?)" title="(.*?)"> <img(?:\s+width="236px" height="338px"|) src="(.*?.jpg)"', data, re.S)
		if movies:
			for (Url, Title, Image) in movies:
				Image = BASEURL + Image
				if Url.startswith('//'):
					Url = "https:" + Url
				self._items.append((decodeHtml(Title), Url, Image))
		if len(self._items) == 0:
			self._items.append((_('No movies found!'), None, None))
		else:
			self.keyLocked = False
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.showInfos()

	def showInfos(self):
		filmName = self['liste'].getCurrent()[0][0]
		self['name'].setText(filmName)
		coverUrl = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(coverUrl, agent=fp_agent, cookieJar=fp_cookies)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		cover = self['liste'].getCurrent()[0][2]
		if url and self.genre == "Neueste Episoden":
			self.session.open(filmPalastEpisodenParsing, stream_name, url)
		elif url:
			self.session.open(filmPalastStreams, stream_name, url, cover)

class filmPalastStreams(MPScreen):

	def __init__(self, session, stream_name, url, cover):
		self.stream_name = stream_name
		self.url = url
		self.cover = cover
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("FilmPalast.to")
		self['ContentTitle'] = Label(_("Stream Selection"))
		self['name'] = Label(self.stream_name)

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		twAgentGetPage(self.url, agent=fp_agent, cookieJar=fp_cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		self._items = []
		self.x = 0
		streams = MPfindall(self, 'currentStreamLinks.*?class="hostName">(.*?)<.*?(?:data-player-url|href)="(.*?)"', data, re.S)
		if streams:
			for (Hoster, Url) in streams:
					if not "hash=" in Url:
						check = isSupportedHoster(Hoster)
						if check:
							self._items.append((check, Url))
					else:
						self.x += 1
						tw_agent_hlp = TwAgentHelper()
						tw_agent_hlp.getRedirectedUrl(Url).addCallback(self.gotStream).addErrback(self.dataError)

		if len(self._items) == 0 and self.x == 0:
			self._items.append((_('No supported streams found!'), None))
		self.ml.setList(list(map(self._defaultlisthoster, self._items)))
		CoverHelper(self['coverArt']).getCover(self.cover, agent=fp_agent, cookieJar=fp_cookies)
		self.keyLocked = False

	def gotStream(self, url):
		self.x -= 1
		check = isSupportedHoster(url)
		if check:
			self._items.append((check, url))
			if len(self._items) == 0 and self.x == 0:
				self._items.append((_('No supported streams found!'), None))
			self.ml.setList(list(map(self._defaultlisthoster, self._items)))

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		url = self['liste'].getCurrent()[0][1]
		if url:
			get_stream_link(self.session).check_link(url, self.playfile)
		else:
			message = self.session.open(MessageBoxExt, _("Broken URL parsing, please report to the developers."), MessageBoxExt.TYPE_INFO, timeout=3)

	def playfile(self, stream_url):
		self.session.open(SimplePlayer, [(self.stream_name, stream_url, self.cover)], showPlaylist=False, ltype='filmpalast', cover=True)