﻿# -*- coding: utf-8 -*-
from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.keyboardext import VirtualKeyBoardExt
from ...resources.twagenthelper import twAgentGetPage
import base64

glob_cookies = CookieJar()
myagent = 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.46 Safari/535.11'
BASE_URL = 'https://streamxxx.tv'

default_cover = "file://%s/streamxxx.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class streamxxxGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("StreamXXX.tv")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.genreData)

	def genreData(self):
		self._items.append(("--- Search ---", None))
		self._items.append(("Newest", "%s/" % BASE_URL))
		self._items.append(("Category", "Category"))
		self._items.append(("Videos", "Videos"))
		self._items.append(("Clips", "%s/category/clips/" % BASE_URL))
		self._items.append(("Movies", "%s/category/movies-xxx/" % BASE_URL))
		self._items.append(("HD Movies", "%s/category/movies-xxx/hd/" % BASE_URL))
		self._items.append(("International Movies", "%s/category/movies/international-movies/" % BASE_URL))
		self._items.append(("German Movies", "%s/category/international-movies/?s=german" % BASE_URL))
		self._items.append(("French Movies", "%s/category/international-movies/?s=french" % BASE_URL))
		self._items.append(("Italian Movies", "%s/category/movies/film-porno-italian/" % BASE_URL))
		self._items.append(("Cento-X-Cento", "%s/tag/cento-x-cento/" % BASE_URL))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			Name = self['liste'].getCurrent()[0][0]
			self.session.open(streamxxxFilmScreen, Link, Name)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Name == "--- Search ---":
			self.suchen()
		elif Name == "Videos" or Name == "Category":
			self.session.open(streamxxxSubGenreScreen, Link, Name)
		else:
			self.session.open(streamxxxFilmScreen, Link, Name)

class streamxxxSubGenreScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("StreamXXX.tv")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''
		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self['name'].setText(_('Please wait...'))
		twAgentGetPage(BASE_URL, agent=myagent).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		if self.Link == "Category":
			preparse = re.search('>TOP TAG(.*?)</ul>', data, re.S|re.I)
			if preparse:
				parse = MPfindall(self, 'href="{0,1}(.*?)"{0,1}\s"{0,1}class="tag-cloud-link.*?>(.*?)</a', preparse.group(1), re.S)
		else:
			preparse = re.search('>VIDEOS <span class="fa(.*?)</ul>', data, re.S|re.I)
			if preparse:
				parse = MPfindall(self, 'href="{0,1}(.*?)"{0,1}(?: class="st-is-cat st-term-\d+"| aria-current=page|)>(.*?)</a', preparse.group(1), re.S)
		if parse:
			for (Url, Title) in parse:
				Title = upperString(Title)
				if not re.match('http', Url):
					Url = "%s%s" % (BASE_URL, Url.strip())
				self._items.append((decodeHtml(Title), Url))
			self._items.sort()
		if len(self._items) == 0:
			self._items.append((_('Nothing found!'), ''))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False
		self['name'].setText("")

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		self.session.open(streamxxxFilmScreen, Link, Name)

class streamxxxFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("StreamXXX.tv")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['name'] = Label(_("Please wait..."))
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self['name'].setText(_('Please wait...'))
		self.keyLocked = True
		self._items = []
		if re.match(".*?Search", self.Name):
			url = "%s/page/%s/?s=%s" % (BASE_URL, str(self.page), self.Link)
		elif re.search('/\?s=', self.Link):
			urlpart = self.Link.split("?s=")
			url = "%spage/%s/?s=%s" % (urlpart[0], str(self.page), urlpart[1])
		else:
			url = self.Link + "page/" + str(self.page) + "/"
		twAgentGetPage(url, agent=myagent).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, 'class=\'{0,1}page-numbers\'{0,1}>(.*?)</ul>', '.*>((?:\d+.|)\d+)<')
		Movies = MPfindall(self, '<article\sid="{0,1}post-\d+.*?<a\shref="{0,1}(.*?)"{0,1}\stitle="(.*?)".*?<img src="{0,1}(.*?)"{0,1}\s.*?(\d+)\sViews', data, re.S)
		if Movies:
			for (Url, Title, Image, Views) in Movies:
				if not re.match('http', Url):
					Url = BASE_URL + "/" + Url
				self._items.append((decodeHtml(Title), Url, Image, Views))
		if len(self._items) == 0:
			self._items.append((_('No movies found!'), None, None, None, None))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		Views = self['liste'].getCurrent()[0][3]
		handlung = "Views: %s" % (Views)
		self['name'].setText(Title)
		self['handlung'].setText(decodeHtml(handlung))
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Title = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		Image = self['liste'].getCurrent()[0][2]
		if Link == None:
			return
		self.session.open(streamxxxStreamListeScreen, Link, Title, Image)

class streamxxxStreamListeScreen(MPScreen):

	def __init__(self, session, streamFilmLink, streamName, streamImage):
		self.streamFilmLink = streamFilmLink
		self.streamName = streamName
		self.streamImage = streamImage
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("StreamXXX.tv")
		self['ContentTitle'] = Label("Streams:")
		self['name'] = Label(_("Please wait..."))

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		CoverHelper(self['coverArt']).getCover(self.streamImage)
		self.keyLocked = True
		self._items = []
		twAgentGetPage(self.streamFilmLink, cookieJar=glob_cookies, agent=myagent).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		data = re.sub(r'http[s]?:\/\/adshrink.*?=\/', '', data)
		parse = re.search('class="st-post-title">(.*?)class=st-post-tags', data, re.S)
		streams = MPfindall(self, '(http[s]?://(.*?)\/.*?)[\'|"|\&|<|\s|>]', parse.group(1), re.S)
		if streams:
			for (stream, hostername) in streams:
				if not stream.endswith('.jpg'):
					check = isSupportedHoster(hostername)
					if check:
						self._items.append((check, stream))
		if len(self._items) == 0:
			self._items.append((_("No supported streams found!"), None))
		self._items = list(set(self._items))
		self.ml.setList(list(map(self._defaultlisthoster, self._items)))
		self.keyLocked = False
		self['name'].setText(self.streamName)

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		if url:
			get_stream_link(self.session).check_link(url, self.got_link)

	def got_link(self, stream_url):
		self.session.open(SimplePlayer, [(self.streamName, stream_url, self.streamImage)], showPlaylist=False, ltype='streamxxx', cover=True)