﻿# -*- coding: utf-8 -*-
from builtins import map
from ...plugin import _
from ...resources.imports import *

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36'
default_cover = "file://%s/incestflix.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
cookies = CookieJar()

class incestflixGenreScreen(MPScreen):

	def __init__(self, session, cat="Sub-genres", name="Genre"):
		self.cat = cat
		self.name = name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel
		}, -1)

		self['title'] = Label("Incestflix.com")
		self['ContentTitle'] = Label(self.name+":")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = "http://www.incestflix.com/alltags"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		parse = re.search('<h1>%s(.*?)(?:<h1>|<br/>|</div>)' % self.cat, data, re.S)
		if parse:
			Cats = MPfindall(self, 'a\shref=[\"|\'](.*?)[\"|\'].*?class=\'studiolink\d+\'>(.*?)</span></a', parse.group(1), re.S)
			if Cats:
				for (Url, Title) in Cats:
						if not "scat" in Title.lower():
							self._items.append((stripAllTags(Title), Url, default_cover))
		self._items.sort()
		if self.cat == "Sub-genres":
			self._items.insert(0, ("Actresses/Performers", "Actresses", default_cover))
			self._items.insert(0, ("Ethnicities", "Ethnicities", default_cover))
			self._items.insert(0, ("Studios/Producers/Series", "Studios", default_cover))
			self._items.insert(0, ("Relations", "Relations", default_cover))
			self._items.insert(0, ("Random", "http://www.incestflix.com/random", default_cover))
			self._items.insert(0, ("Newest", "http://www.incestflix.com", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.ml.moveToIndex(0)
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Link.startswith('http'):
			self.session.open(incestflixFilmScreen, Link, Name)
		else:
			self.session.open(incestflixGenreScreen, Link, Name)

class incestflixFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("Incestflix.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		url = "%s/page/%s" % (self.Link, str(self.page))
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		self.getLastPage(data, 'id=\'incflix-pager\'>(.*?)</table>')
		Movies = MPfindall(self, "id='videolink'\shref='(.*?)'.*?text-heading'>(.*?)</div.*?background:\surl\((.*?)\);", data, re.S)
		if Movies:
			for (Url, Title, Image) in Movies:
				self._items.append((decodeHtml(Title), Url, Image))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		pic = self['liste'].getCurrent()[0][2]
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			twAgentGetPage(Link, cookieJar=cookies, agent=agent).addCallback(self.parseVideo).addErrback(self.dataError)

	def parseVideo(self, data):
		streams = MPfindall(self, "<source src=[\"|\'](http.*?)[\"|\']", data, re.S)
		if streams:
			Title = self['liste'].getCurrent()[0][0]
			self.session.open(SimplePlayer, [(Title, streams[-1])], showPlaylist=False, ltype='incestflix')