﻿# -*- coding: utf-8 -*-
from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
default_cover = "file://%s/freeomovie.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

free_cookies = CookieJar()
free_agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36'

BASE_URL = "https://www.freeomovie.to"

class freeomovieGenreScreen(MPScreen):

	def __init__(self, session):

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self.keyLocked = True
		self.language = "de"
		self.suchString = ''
		self['title'] = Label("freeomovie.to")
		self['ContentTitle'] = Label("Genres")

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = BASE_URL
		twAgentGetPage(url, agent=free_agent, cookieJar=free_cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		parse = re.search('Categories</h2>(.*?)</div>', data, re.S)
		Cat = MPfindall(self, 'href="(.*?)".*?>(.*?)</a>', parse.group(1), re.S)
		if Cat:
			for (Url, Title) in Cat:
				Url = Url + "page/"
				if Title not in ["XXX Comics", "XXX Games"]:
					self._items.append((Title, Url))
			self._items.sort()
			self._items.insert(0, ("Newest", "https://www.freeomovie.to/page/"))
			self._items.insert(0, ("--- Search ---", "callSuchen", None))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
			self.keyLocked = False

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = '%s' % urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(freeomovieFilmListeScreen, Link, Name)

	def keyOK(self):
		if self.keyLocked:
			return
		freeomovieGenre = self['liste'].getCurrent()[0][0]
		freeomovieUrl = self['liste'].getCurrent()[0][1]
		if freeomovieGenre == "--- Search ---":
			self.suchen()
		else:
			self.session.open(freeomovieFilmListeScreen, freeomovieUrl, freeomovieGenre)

class freeomovieFilmListeScreen(MPScreen):

	def __init__(self, session, genreLink, genreName):
		self.genreLink = genreLink
		self.genreName = genreName
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self.keyLocked = True
		self.page = 1
		self.lastpage = 1
		self['title'] = Label("freeomovie.to")
		self['ContentTitle'] = Label("%s" % self.genreName)
		self['name'] = Label("Film Auswahl")
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		if re.match(".*?Search", self.genreName):
			url = "https://www.freeomovie.to/page/%s/?s=%s" % (str(self.page), self.genreLink)
		else:
			url = "%s%s" % (self.genreLink, str(self.page))
		twAgentGetPage(url, agent=free_agent, cookieJar=free_cookies).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self.getLastPage(data, 'class=[\"|\']wp-pagenavi[\"|\'](.*?)</div>')
		movies = MPfindall(self, 'class="boxtitle">.*?<a href="(.*?)".*?title="(.*?)".*?<img (?:class="rmbd" |)src="(.*?)"', data, re.S)
		if movies:
			self._items = []
			for (url, title, image) in movies:
				self._items.append((decodeHtml(title), url, image))
			self._setList('_defaultlistleft', True)
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		streamTitle = self['liste'].getCurrent()[0][0]
		streamUrl = self['liste'].getCurrent()[0][1]
		streamPic = self['liste'].getCurrent()[0][2]
		self['name'].setText(streamTitle)
		CoverHelper(self['coverArt']).getCover(streamPic)
		twAgentGetPage(streamUrl, agent=free_agent, cookieJar=free_cookies).addCallback(self.getDescription).addErrback(self.dataError)

	def getDescription(self, data):
		ddDescription = re.search('name="description"\scontent="(.*?)"', data, re.S)
		if ddDescription:
			self['handlung'].setText(decodeHtml(ddDescription.group(1)))
		else:
			self['handlung'].setText('')

	def keyOK(self):
		if self.keyLocked:
			return
		title = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		image = self['liste'].getCurrent()[0][2]
		self.session.open(freeomovieFilmAuswahlScreen, title, url, image)

class freeomovieFilmAuswahlScreen(MPScreen):

	def __init__(self, session, genreName, genreLink, cover):
		self.genreLink = genreLink
		self.genreName = genreName
		self.cover = cover
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("freeomovie.to")
		self['ContentTitle'] = Label("Streams")
		self['name'] = Label(self.genreName)


		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		twAgentGetPage(self.genreLink, agent=free_agent, cookieJar=free_cookies).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		parse = re.search('class="videosection(.*?)class="textsection', data, re.S)
		streams = MPfindall(self, '(http[s]?://(?!(www.google.com))(.*?)\/.*?)[\'|"|\&|<]', parse.group(1), re.S)
		if streams:
			for (stream, dummy, hostername) in streams:
				check = isSupportedHoster(hostername)
				if check:
					self._items.append((check, stream))
			# remove duplicates
			self._items = list(set(self._items))
		if len(self._items) == 0:
			self._items.append(("No supported streams found!", None))
		self.ml.setList(list(map(self._defaultlisthoster, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		if url:
			url = url.replace('&amp;', '&').replace('&#038;', '&')
			get_stream_link(self.session).check_link(url, self.got_link)

	def got_link(self, stream_url):
		title = self.genreName
		self.session.open(SimplePlayer, [(title, stream_url, self.cover)], showPlaylist=False, ltype='freeomovie', cover=True)