#!/bin/bash
# Provides: jungle-team
# Description: Add one line in cccam or oscam protocol
# Version: 1.0
# Date: 08/12/2020
# Usage: /usr/bin/addline.sh C: server port username password
# Telegram: https://t.me/joinchat/AFo2KEfzM5Tk7y3VgcqIOA

num_params=$#
number=$(echo $(($RANDOM)))
oscamdir="/etc/tuxbox/config/ncam"
oscamserver="${oscamdir}/ncam.server"

if [ "$num_params" == 5 ];
then
    type_c=$1
    server=$2
    port=$3
    username=$4
    pass=$5
else
    echo "Incorrect number of parameters"
    echo "Usage: /usr/bin/addline.sh C: server.com 33333 user-team pass-team"
    exit 1
fi


if [ ! -f $oscamserver ];
then
    echo "${oscamserver} file doesn't exist"
    exit 1
else
    {
    echo ""
    echo "[reader]"                                              
    echo "label                         = ${server}-${port}-$number"
    echo "protocol                      = cccam"                        
    echo "device                        = ${server},${port}"            
    echo "user                          = ${username}"                  
    echo "password                      = ${pass}"                      
    echo "enable                        = 1"                            
    echo "inactivitytimeout             = 30"                           
    echo "fallback                      = 1"                
    echo "group                         = 1"                
    echo "cccversion                    = 2.3.2"      
    echo "ccckeepalive                  = 1" 
    } >> ${oscamserver}
    salida=$?
fi

if [ "$salida" -eq 0 ];
then
    echo "Ncam line added correctly"
    echo "telegram: https://t.me/joinchat/Bv0_2hZ8jH6dsUJFoYG-Rg"
    exit 0
else
    exit 1
fi