# -*- coding: utf-8 -*-
from Screens.Screen import Screen
from Components.Sources.StaticText import StaticText
from Components.Pixmap import Pixmap
from Components.Console import Console as iConsole
from Components.ActionMap import ActionMap
from Components.Sources.List import List
from Components.Label import Label
from Plugins.Plugin import PluginDescriptor
from Components.Language import language
from Tools.LoadPixmap import LoadPixmap
import os
import enigma
from Screens.MessageBox import MessageBox
from Components.Console import Console as iConsole
from Screens.Console import Console
import commands

class wizard_jungle(Screen):

	skin = """
		<screen name="wizard_jungle" position="0,0" size="1280,720" flags="wfNoBorder" backgroundColor="transparent">
     <eLabel position="center,center" size="1000,500" transparent="0" zPosition="-11" backgroundColor="#10f4f4fc"/>
    <eLabel position="140,75" size="1000,40" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#330042b3" zPosition="-10"/>
    <eLabel position="140,115" size="10,495" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#330042b3" zPosition="-10"/>
    <eLabel position="1130,115" size="10,495" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#330042b3" zPosition="-10"/>
    <eLabel position="140,600" size="1000,10" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#330042b3" zPosition="-10"/>
    <eLabel position="150,570" size="980,30" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#c4c4c4" zPosition="-10"/>
    <eLabel position="150,570" size="980,2" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#A4A4A4" zPosition="-10"/>
    <widget source="Title" transparent="1" render="Label" zPosition="2" halign="left" position="160,85" size="600,60" font="Regular; 20" foregroundColor="white" backgroundColor="#330042b3" noWrap="1"/>
<widget source="header" render="Label" position="600,180" size="500,300" foregroundColor="black" backgroundColor="white" font="Regular; 25" halign="left" transparent="1" />
<widget source="contenido" render="Label" position="600,300" size="500,300" foregroundColor="#949492" backgroundColor="#10f4f4fc" font="Regular; 18" halign="left" transparent="1" />
<ePixmap name="icono" position="160,120" size="389,450" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/wizard_jungle.png" zPosition="-5" />
<ePixmap name="blue" position="960,575" size="138,23" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/blue150x30.png" zPosition="-5" />
<widget source="key_blue" render="Label" position="992,578" size="200,50" zPosition="3" font="Regular; 14" transparent="1" backgroundColor="black" foregroundColor="white" noWrap="1" />
<ePixmap name="red" position="790,575" size="138,23" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/red150x30.png" zPosition="-5" />
<widget source="key_red" render="Label" position="825,578" size="200,50" zPosition="3" font="Regular; 14" transparent="1" backgroundColor="black" foregroundColor="white" noWrap="1" />
<ePixmap name="icono" position="1020,460" size="100,100" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/james_icon.png" zPosition="-5" />


</screen>"""

	
	def __init__(self, session):
		self.session = session
		Screen.__init__(self, session)
		self.skinName = "wizard_jungle"
		self.setTitle(_("James Donkey Wizard"))
		self.indexpos = None
		self["shortcuts"] = ActionMap(["ShortcutActions", "WizardActions", "InputBoxActions"],
		{
			"cancel": self.exit,
			"back": self.exit,
			"red": self.exit,
			"blue": self.asistente,
		
			
		})

		self["key_red"] = StaticText(_("Cancelar"))
		self["key_blue"] = StaticText(_("Siguiente"))
		self["header"] = StaticText(_("Bienvenido al Wizard OpenATV James Donkey"))
		self["contenido"] = StaticText(_("Has accedido al asistente Wizard de instalacion de complementos para James Donkey realizando por Jungle-Team, siga los pasos para la instalacion de lo que necesites, una vez finalizado tendra su receptor listo para su funcionamiento, si tienes alguna duda visite www.jungle-team.com."))
		
	def exit(self):
		self.close()
		
	def asistente(self):
		self.session.open(install_donkey)


	
class install_donkey(Screen):

	skin = """
		<screen name="install_donkey" position="0,0" size="1280,720" flags="wfNoBorder" backgroundColor="transparent">
     <eLabel position="center,center" size="1000,500" transparent="0" zPosition="-11" backgroundColor="#10f4f4fc"/>
    <eLabel position="140,75" size="1000,40" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#330042b3" zPosition="-10"/>
    <eLabel position="140,115" size="10,495" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#330042b3" zPosition="-10"/>
    <eLabel position="1130,115" size="10,495" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#330042b3" zPosition="-10"/>
    <eLabel position="140,600" size="1000,10" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#330042b3" zPosition="-10"/>
    <eLabel position="150,570" size="980,30" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#c4c4c4" zPosition="-10"/>
    <eLabel position="150,570" size="980,2" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#A4A4A4" zPosition="-10"/>
    <widget source="Title" transparent="1" render="Label" zPosition="2" halign="left" position="160,85" size="600,60" font="Regular; 20" foregroundColor="white" backgroundColor="#330042b3" noWrap="1"/>
<widget source="header" render="Label" position="160,125" size="500,300" foregroundColor="black" backgroundColor="white" font="Regular; 25" halign="left" transparent="1" />
<widget source="contenido" render="Label" position="160,200" size="500,300" foregroundColor="#949492" backgroundColor="#10f4f4fc" font="Regular; 18" halign="left" transparent="1" />
		
		<widget source="key_green" render="Label" position="775,430" size="300,50" zPosition="3" font="Regular; 30" backgroundColor="green" transparent="1" foregroundColor="white" noWrap="1" />
		<widget source="key_yellow" render="Label" position="775,285" size="300,50" zPosition="3" font="Regular; 30" backgroundColor="yellow" transparent="1" foregroundColor="black" noWrap="1" />
<widget source="key_blue" render="Label" position="775,140" size="300,50" zPosition="3" font="Regular; 30" transparent="1" backgroundColor="blue" foregroundColor="white" noWrap="1" />

<eLabel position="700,130" size="390,130" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="#0000ff" zPosition="-10"/>
<ePixmap name="menu" position="840,325" size="80,80" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/bot.png" zPosition="-5" />
<eLabel position="700,275" size="390,130" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="yellow" zPosition="-10"/>
<ePixmap name="menu" position="840,465" size="80,80" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/ghostreamy.png" zPosition="-5" />
<eLabel position="700,420" size="390,130" transparent="0" foregroundColor="#10f4f4fc" backgroundColor="green" zPosition="-10"/>
<ePixmap name="menu" position="840,180" size="150,151" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/junglescript.png" zPosition="-5" />
<ePixmap name="menu" position="180,350" size="450,203" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/reciver.png" zPosition="-5" />
<ePixmap name="menu" position="160,575" size="35,25" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/key_0.png" zPosition="-5" />
<widget source="key_0" render="Label" position="200,580" size="200,50" zPosition="3" font="Regular; 15" backgroundColor="#c4c4c4" transparent="1" foregroundColor="black" noWrap="1" />
<ePixmap name="menu" position="360,575" size="35,25" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/key_1.png" zPosition="-5" />
<widget source="key_1" render="Label" position="405,580" size="200,50" zPosition="3" font="Regular; 15" backgroundColor="#c4c4c4" transparent="1" foregroundColor="black" noWrap="1" />
<ePixmap name="menu" position="535,575" size="35,25" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/key_2.png" zPosition="-5" />
<widget source="key_2" render="Label" position="575,580" size="200,50" zPosition="3" font="Regular; 15" backgroundColor="#c4c4c4" transparent="1" foregroundColor="black" noWrap="1" />
<ePixmap name="menu" position="760,575" size="35,25" alphatest="blend" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/JungleWizard/iconos/key_3.png" zPosition="-5" />
<widget source="key_3" render="Label" position="800,580" size="200,50" zPosition="3" font="Regular; 15" backgroundColor="#c4c4c4" transparent="1" foregroundColor="black" noWrap="1" />

</screen>"""

	
	def __init__(self, session):
		self.session = session
		Screen.__init__(self, session)
		self.skinName = "install_donkey"
		self.setTitle(_("James Donkey Wizard instalacion"))
		self.indexpos = None
		self["shortcuts"] = ActionMap(["ShortcutActions", "WizardActions", "InputBoxActions"],
		{
			"cancel": self.exit,
			"back": self.exit,
			"red": self.exit,
			"blue": self.install_junglescript,
			"yellow": self.install_junglebot,
			"0": self.install_repositorios,
			"1": self.install_full,
			"2": self.install_conclave,
			"3": self.install_koala,
			"green": self.ghostreamy,
			
			
		})

		self["key_red"] = StaticText(_("Cancel"))
		self["key_blue"] = StaticText(_("JUNGLESCRIPT"))
		self["key_green"] = StaticText(_("GHOSTREAMY"))
		self["key_yellow"] = StaticText(_("JUNGLEBOT"))
		self["key_0"] = StaticText(_("Instalar repositorios"))
		self["key_1"] = StaticText(_("Instalacion Full"))
		self["key_2"] = StaticText(_("Instalar Oscam-Conclave"))
		self["key_3"] = StaticText(_("Instalar EPG Koala"))
		self["header"] = StaticText(_("Asistente de instalacion utilidades James Donkey"))
		self["contenido"] = StaticText(_("Menu de instalacion utilidades para receptor James Donkey con imagen OpenATV, presione 1 para una instalacion completa o seleccione individualmente que deseas instalar, en caso de realizar instalaciones individuales instalar previamente repositorios con boton 0."))
		
	def exit(self):
		self.close()

			
	def install_junglescript(self):
		cmdlist = []
		cmdlist.append('opkg update')
		cmdlist.append('opkg install enigma2-plugin-extensions-junglescript')
		cmdlist.append('echo "_________________________________________________\n"')
		cmdlist.append('echo "' + _("  Realizada instalacion Junglescript  ") + '"')
		cmdlist.append('echo "_________________________________________________\n"')
		self.session.open(Console, title = _("Instalando JungleScript"), cmdlist = cmdlist, closeOnSuccess = False)
		
	def install_junglebot(self):
		cmdlist = []
		cmdlist.append('opkg update')
		cmdlist.append('opkg install enigma2-plugin-extensions-junglebot')
		cmdlist.append('echo "_________________________________________________\n"')
		cmdlist.append('echo "' + _("  Realizada instalacion Junglebot  ") + '"')
		cmdlist.append('echo "_________________________________________________\n"')
		self.session.open(Console, title = _("Instalando Junglebot"), cmdlist = cmdlist, closeOnSuccess = False)


	def install_repositorios(self):
		cmdlist = []
		cmdlist.append('echo "' + _("Se va a proceder a instalar repositorios extra OpenATV! ") + '"')
		cmdlist.append('wget -O - -q http://updates.mynonpublic.com/oea/feed | bash')
		cmdlist.append('wget http://tropical.jungle-team.online/script/jungle-feed.conf -P /etc/opkg/')
		self.session.open(Console, title = _("Instalando Repositorios Extra"), cmdlist = cmdlist, closeOnSuccess = False)

	def ghostreamy(self):
		cmdlist = []
		cmdlist.append('opkg update')
		cmdlist.append('opkg install enigma2-plugin-extensions-ghostreamy-arm')
		cmdlist.append('echo "_________________________________________________\n"')
		cmdlist.append('echo "' + _("  Realizada instalacion Ghostreamy  ") + '"')
		cmdlist.append('echo "_________________________________________________\n"')
		self.session.open(Console, title = _("Instalando Ghostreamy"), cmdlist = cmdlist, closeOnSuccess = False)

	def install_conclave(self):
		cmdlist = []
		cmdlist.append('opkg update')
		cmdlist.append('opkg install enigma2-plugin-softcams-oscam-conclave')
		cmdlist.append('echo "_________________________________________________\n"')
		cmdlist.append('echo "' + _("  Realizada instalacion Oscam-Conclave  ") + '"')
		cmdlist.append('echo "_________________________________________________\n"')
		self.session.open(Console, title = _("Instalando Oscam-Conclave"), cmdlist = cmdlist, closeOnSuccess = False)


	def install_koala(self):
		cmdlist = []
		cmdlist.append('opkg update')
		cmdlist.append('opkg install enigma2-plugin-extensions-epgimport-old')
		cmdlist.append('echo "_________________________________________________\n"')
		cmdlist.append('echo "' + _("  Realizada Koala Epg  ") + '"')
		cmdlist.append('echo "_________________________________________________\n"')
		self.session.open(Console, title = _("Instalando Koala Epg"), cmdlist = cmdlist, closeOnSuccess = False)



	def install_full(self):
		cmdlist = []
		cmdlist.append('wget -O - -q http://updates.mynonpublic.com/oea/feed | bash')
		cmdlist.append('wget http://tropical.jungle-team.online/script/jungle-feed.conf -P /etc/opkg/')
		cmdlist.append('opkg update')
		cmdlist.append('opkg install enigma2-plugin-extensions-junglescript')
		cmdlist.append('opkg install enigma2-plugin-extensions-ghostreamy-arm')
		cmdlist.append('opkg install enigma2-plugin-extensions-epgimport-old')
		cmdlist.append('opkg install enigma2-plugin-softcams-oscam-conclave')
		cmdlist.append('opkg install enigma2-plugin-extensions-junglebot')
		cmdlist.append('opkg install enigma2-plugin-softcams-oscam-trunk-ipv4only')
		cmdlist.append('opkg install zerotierarm')
		cmdlist.append('echo "_________________________________________________\n"')
		cmdlist.append('echo "' + _("  Instalacion Full utilidades finalizada ") + '"')
		cmdlist.append('echo "_________________________________________________\n"')
		self.session.open(Console, title = _("Realizando instalacion Full"), cmdlist = cmdlist, closeOnSuccess = False)

######################################################################################	

def main(session, **kwargs):
	session.open(wizard_jungle)
	
######################################################################################
def sessionstart(reason,session=None, **kwargs):
	if reason == 0:
		pTools.gotSession(session)
######################################################################################

def Plugins(**kwargs):
	list = [PluginDescriptor(name=_("Wizard James Donkey"), description=_("www.jungle-Team.com"), where = [PluginDescriptor.WHERE_PLUGINMENU], icon="wizard.png", fnc=main)]
	
	return list
